package com.maddox.il2.objects.air;

import com.maddox.il2.ai.BulletEmitter;
import com.maddox.il2.ai.World;
import com.maddox.il2.engine.Config;
import com.maddox.il2.engine.HierMesh;
import com.maddox.il2.fm.*;
import com.maddox.il2.game.Main3D;
import com.maddox.rts.Property;

public class I_301 extends LAGG_3E
    implements TypeTNBFighter
{

    public I_301()
    {
        oldbullets = -123;
        recoilTime = 0.0F;
        kangle = 0.0F;
        kl = 1.0F;
        kr = 1.0F;
        kc = 1.0F;
    }

    public void rareAction(float paramFloat, boolean paramBoolean)
    {
        super.rareAction(paramFloat, paramBoolean);
        if(paramBoolean)
        {
			//Код перекидывания огня на соседний бак, вероятность 14%
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[0] > 4 && World.Rnd().nextFloat() < 0.14F)
                ((FlightModelMain) (super.FM)).AS.hitTank(this, 2, 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[1] > 4 && World.Rnd().nextFloat() < 0.14F)
                ((FlightModelMain) (super.FM)).AS.hitTank(this, 2, 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[2] > 4 && World.Rnd().nextFloat() < 0.14F)
                ((FlightModelMain) (super.FM)).AS.hitTank(this, 0, 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[2] > 4 && World.Rnd().nextFloat() < 0.14F)
                ((FlightModelMain) (super.FM)).AS.hitTank(this, 1, 1);
        }
    }

    public static void moveGear(HierMesh hiermesh, float f, float f1, float f2)
    {
        hiermesh.chunkSetAngles("GearL2_D0", 0.0F, 80F * f * kl, 0.0F);
        hiermesh.chunkSetAngles("GearR2_D0", 0.0F, -80F * f1 * kr, 0.0F);
        hiermesh.chunkSetAngles("GearL3_D0", 0.0F, -100F * f * kl, 0.0F);
        hiermesh.chunkSetAngles("GearR3_D0", 0.0F, 100F * f1 * kr, 0.0F);
        hiermesh.chunkSetAngles("GearL4_D0", 0.0F, 95F * f * kl, 0.0F);
        hiermesh.chunkSetAngles("GearR4_D0", 0.0F, -95F * f1 * kr, 0.0F);
        Aircraft.xyz[0] = Aircraft.xyz[1] = Aircraft.xyz[2] = 0.0F;
        Aircraft.ypr[0] = Aircraft.ypr[1] = Aircraft.ypr[2] = 0.0F;
        Aircraft.xyz[2] = Aircraft.cvt(f, 0.0F, 1.0F, 0.0F, 0.1F);
        hiermesh.chunkSetLocate("poleL_D0", Aircraft.xyz, Aircraft.ypr);
        hiermesh.chunkSetLocate("poleR_D0", Aircraft.xyz, Aircraft.ypr);
    }

    protected void moveGear(float f, float f1, float f2)
    {
        moveGear(hierMesh(), f, f1, f2);
        if(((FlightModelMain) (super.FM)).CT.getGear() >= 0.997F)
        {
            kl = 1.0F;
            kr = 1.0F;
            kc = 1.0F;
		}
    }

    public void onAircraftLoaded()
    {
        if(!thisWeaponsName.startsWith("none"))
            g1 = FM.CT.Weapons[1][0];
    }

    public void update(float f)
    {
        if(g1 != null)
            if(recoilTime > 0.0F)
            {
                recoilTime += f;
                float f1 = recoilTime * (4.8F + recoilTime * (-8.3F + recoilTime * 3.5F));
                if(recoilTime > 1.0F)
                {
                    f1 = 0.0F;
                    recoilTime = 0.0F;
                    oldbullets = g1.countBullets();
                }
                if(World.cur().diffCur.Realistic_Gunnery)
                {
                    float f2 = (float)FM.getBallAccel().y;
                    f2 = (f2 * f2 - 0.2F) * 0.2F * f;
                    if(f2 > World.Rnd().nextFloat())
                        FM.AS.setJamBullets(1, 0);
                }
            } else
            if(g1.isShots() && oldbullets != g1.countBullets())
                recoilTime += f;
        super.hierMesh().chunkSetAngles("Oil_luk", 0.0F, -9F + 9F * kangle, 0.0F);
        kangle = 0.95F * kangle + 0.05F * FM.EI.engines[0].getControlRadiator();
        super.update(f);
    }

    static Class _mthclass$(String s)
    {
        Class class1;
        try
        {
            class1 = Class.forName(s);
        }
        catch(ClassNotFoundException classnotfoundexception)
        {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
        return class1;
    }

    private BulletEmitter g1;
    private int oldbullets;
    private float recoilTime;
    private float kangle;
    private static float kl = 1.0F;
    private static float kr = 1.0F;
    private static float kc = 1.0F;

    static 
    {
        Class class1 = com.maddox.il2.objects.air.I_301.class;
        new NetAircraft.SPAWN(class1);
        Property.set(class1, "iconFar_shortClassName", "I-301");
        Property.set(class1, "meshName", "3do/plane/I-301/hier.him");
        Property.set(class1, "PaintScheme", new PaintSchemeFMPar01());
        Property.set(class1, "yearService", 1940F);
        Property.set(class1, "yearExpired", 1941F);
        Property.set(class1, "FlightModel", "FlightModels/I-301.fmd:LAGG");
        Property.set(class1, "cockpitClass", new Class[] {
            com.maddox.il2.objects.air.CockpitLAGG_3_301.class
        });
        Property.set(class1, "LOSElevation", 0.69445F);
        Aircraft.weaponTriggersRegister(class1, new int[] {
            0, 0, 1
        });
        Aircraft.weaponHooksRegister(class1, new String[] {
            "_MGUN01", "_MGUN02", "_CANNON01"
        });
    }
}